class Item_Ammo extends TournamentPickup;

var int AmmoRegenTime;

event float BotDesireability(Pawn Bot)
{
	return (0); 
}

auto state Pickup
{	
	function Touch( actor Other )
		{
		if ( ValidTouch(Other) && Other.IsA('PlayerPawn')) 
			{
			MonsterPRI(PlayerPawn(Other).PlayerReplicationInfo).AmmoRegenTime += AmmoRegenTime;
			PlayerPawn(Other).ReceiveLocalizedMessage( class'PickupMessagePlus', 0, None, None, Self.Class );
			PlaySound (PickupSound,,2.5);
			Other.MakeNoise(0.2);		
			SetRespawn();	
			}

		}
	function BeginState()
		{
		SetTimer(1.0,True);
		}
}

defaultproperties
{
     bDisplayableInv=True
     PickupMessage="You got the Ammo regenerator!"
     ItemName="Ammo Regenerator"
     RespawnTime=0.000000
     PickupViewMesh=Mesh'HealthItem'
     MaxDesireability=2.000000
     PickupSound=Sound'Botpack.Pickups.ArmorUT'
     Mesh=Mesh'HealthItem'
     AmbientGlow=64
     MultiSkins(0)=Texture'Item_Ammo'
     CollisionRadius=16.00000
     CollisionHeight=16.00000
     bCollideWhenPlacing=True
     bRotatingPickup=True
     RotationRate=(Roll=32768)
     RotationRate=(Pitch=26000)
     RotationRate=(Yaw=19200)
     LightEffect=LE_Shock
     LightBrightness=64
     LightHue=85
     LightRadius=16
     LightSaturation=64
     LightType=LT_Steady
     Charge=1
     ArmorAbsorption=75
     bIsAnArmor=True
}
